@extends('admin.layouts.master')

@section('extra_css')
    <link rel="stylesheet" type="text/css" href="/assets/plugins/select2/select2.css"/>
    <link rel="stylesheet" type="text/css"
          href="/assets/plugins/datatables/extensions/Scroller/css/dataTables.scroller.min.css"/>
    <link rel="stylesheet" type="text/css"
          href="/assets/plugins/datatables/extensions/ColReorder/css/dataTables.colReorder.min.css"/>
    <link rel="stylesheet" type="text/css"
          href="/assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css"/>
@stop

@section('extra_js')
    <script type="text/javascript" src="/assets/plugins/select2/select2.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/datatables/media/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript"
            src="/assets/plugins/datatables/extensions/TableTools/js/dataTables.tableTools.min.js"></script>
    <script type="text/javascript"
            src="/assets/plugins/datatables/extensions/ColReorder/js/dataTables.colReorder.min.js"></script>
    <script type="text/javascript"
            src="/assets/plugins/datatables/extensions/Scroller/js/dataTables.scroller.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            Metronic.handleTables();
        });
    </script>
@stop

@section('content')

    <h3 class="page-title">
        Ads Section
        <small>Manage Ads</small>
    </h3>

    <div class="page-bar">
        <ul class="page-breadcrumb">

            <li>
                <a href="/admin">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/ads">Ads Section</a>
            </li>

        </ul>
    </div>

    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet box green-meadow">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-puzzle"></i>All Ads
                    </div>
                    <div class="actions">
                        <a href="/admin/ads/create" class="btn red">
                            <i class="fa fa-plus"></i> Create New Ad </a>
                    </div>
                </div>

                <div class="portlet-body">

                    @include('admin.layouts.notify')

                    <table class="table table-striped table-bordered table-hover" id="datatable_advanced">
                        <thead>
                        <tr>
                            <th>
                                ID
                            </th>
                            <th>
                                Code
                            </th>
                            <th>
                                Position
                            </th>
                            <th>Edit</th>
                            <th>Delete</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($ads as $ad)
                            <tr>
                                <td> {{$ad->id}} </td>
                                <td> {{$ad->code}} </td>

                                @if($ad->position == \App\Ads::TYPE_INDEX_HEADER)
                                    <td> Index Page Header</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_INDEX_FOOTER)
                                    <td> Index Page Footer</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_SIDEBAR)
                                    <td> Sidebar</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_ABOVE_POST)
                                    <td> Above Each Post</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_BELOW_POST)
                                    <td> Below Each Post</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_BETWEEN_CATEGORY_INDEX)
                                    <td> Between Category Pages</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_BETWEEN_SUBCATEGORY_INDEX)
                                    <td> Between Sub Category Pages</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_BETWEEN_AUTHOR_INDEX)
                                    <td> Between Author Pages</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_BETWEEN_TAG_INDEX)
                                    <td> Between Tag Pages</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_BETWEEN_SEARCH_INDEX)
                                    <td> Between Search Pages</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_ABOVE_PAGE)
                                    <td> Above Each Page</td>
                                @endif

                                @if($ad->position == \App\Ads::TYPE_BELOW_PAGE)
                                    <td> Below Each Page</td>
                                @endif

                                <td><a href="/admin/ads/edit/{{$ad->id}}" class="btn btn-warning btn-sm">Edit</a>
                                </td>
                                <td><a data-href="/admin/ads/delete/{{$ad->id}}" data-toggle="modal"
                                       data-target="#confirm-delete" class="btn btn-danger btn-sm">Delete</a></td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                    <div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog"
                         aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    Delete Ad ?
                                </div>
                                <div class="modal-body" style="background-color:#FFB848; color:#ffffff;">
                                    <h4><i class="fa fa-exclamation-triangle"></i> Are you sure that you want to delete
                                        this Ad ?
                                    </h4>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                    <a class="btn btn-danger btn-ok">Delete</a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
@stop